% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRISPRball.R
\name{CRISPRball}
\alias{CRISPRball}
\title{Create an interactive Shiny app for visualization & exploration of CRISPR analyses}
\usage{
CRISPRball(
  gene.data = NULL,
  sgrna.data = NULL,
  count.summary = NULL,
  norm.counts = NULL,
  h.id = "mag1",
  positive.ctrl.genes = NULL,
  essential.genes = NULL,
  depmap.db = NULL,
  genesets = NULL,
  return.app = TRUE
)
}
\arguments{
\item{gene.data}{A named list containing \code{gene_summary.txt} tables as data.frames.
Multiple data.frames may be provided, one per element of the list.
Users will be able to swap between them within the app. List element names should match names of \code{sgrna.data} list elements.}

\item{sgrna.data}{A named list containing \code{sgrna_summary.txt} tables as data.frames.
Multiple data.frames may be provided, one per element of the list.
Users will be able to swap between them within the app. List element names should match names of \code{gene.data} list elements.}

\item{count.summary}{Matrix or dataframe containing count summary (\code{countsummary.txt}) as generated by \code{mageck count}.}

\item{norm.counts}{Matrix or dataframe containing normalized counts (\code{count_normalized.txt}) as generated by \code{mageck count}.}

\item{h.id}{String indicating unique ID for interactive plots.
Required if multiple apps are run within the same Rmd file.}

\item{positive.ctrl.genes}{Optional character vector of gene identifiers for
positive control genes from the screen so that they can be easily filtered.}

\item{essential.genes}{Optional character vector of gene identifiers of common
essential genes (i.e. pan-lethal) so that they can be easily filtered.
If provided, overrides the depmap essential genes.}

\item{depmap.db}{Optional character scalar for name of SQLite database returned by \code{\link{build_depmap_db}}.}

\item{genesets}{Optional named list containing genesets that can be interactively highlighted on the plots.
The elements of the list should each be a geneset with gene identifiers matching those used in the results.}

\item{return.app}{Optional boolean indicating whether a Shiny app should be returned. \code{TRUE} by default. If \code{FALSE},
a named list of app elements (ui and server) will be returned instead. Useful for deploying as a standalone shiny app.}
}
\value{
A Shiny app containing interactive visualizations of CRISPR analysis results.
}
\description{
Create an interactive Shiny app for visualization & exploration of CRISPR analyses
}
\details{
Features with no variation will be removed prior to \code{\link[PCAtools]{pca}} being run for the PCA visualization.
Gene labels can be added to the MAplot and volcano plot by clicking a point. The labels can also be dragged around,
though adding labels will reset the positions, so it's recommended to add all labels prior to re-positioning them.
}
\examples{
library(CRISPRball)
# Create app with no data loaded.
app <- CRISPRball()
if (interactive()) {
    shiny::runApp(app)
}

# Create app with data loaded.
# Create lists of results summaries for each dataset.
d1.genes <- read.delim(system.file("extdata", "esc1.gene_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)
d2.genes <- read.delim(system.file("extdata", "plasmid.gene_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)

d1.sgrnas <- read.delim(system.file("extdata", "esc1.sgrna_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)
d2.sgrnas <- read.delim(system.file("extdata", "plasmid.sgrna_summary.txt",
    package = "CRISPRball"
), check.names = FALSE)

count.summ <- read.delim(system.file("extdata", "escneg.countsummary.txt",
    package = "CRISPRball"
), check.names = FALSE)
norm.counts <- read.delim(system.file("extdata", "escneg.count_normalized.txt",
    package = "CRISPRball"
), check.names = FALSE)

genes <- list(ESC = d1.genes, plasmid = d2.genes)
sgrnas <- list(ESC = d1.sgrnas, plasmid = d2.sgrnas)

app <- CRISPRball(
    gene.data = genes, sgrna.data = sgrnas,
    count.summary = count.summ, norm.counts = norm.counts
)
if (interactive()) {
    shiny::runApp(app)
}
}
\author{
Jared Andrews, Jacob Steele
}
