% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_depmap.R
\name{plot_depmap_dependency}
\alias{plot_depmap_dependency}
\title{Plot gene dependency information from DepMap CRISPR and RNAi tables}
\usage{
plot_depmap_dependency(
  df,
  crispr.color = "#3584B5",
  rnai.color = "#52288E",
  depline = TRUE,
  plot.grid = FALSE
)
}
\arguments{
\item{df}{data.frame containing information for a single gene
as returned by \code{\link{get_depmap_plot_data}}.}

\item{crispr.color}{Character scalar for CRISPR trace color as hexcode.}

\item{rnai.color}{Character scalar for RNAi trace color as hexcode.}

\item{depline}{Boolean indicating whether to show the dependency threshold line.}

\item{plot.grid}{Boolean indicating whether to plot gridlines.}
}
\value{
plotly object
}
\description{
Plot gene dependency information from DepMap CRISPR and RNAi tables
}
\examples{
library(CRISPRball)
data(depmap_22q1_crispr_rnai)
plot_depmap_dependency(depmap_22q1_crispr_rnai)
}
\seealso{
\code{\link{get_depmap_plot_data}}
}
\author{
Jared Andrews
}
