% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data_upload.R
\name{read_mle_gene_summary}
\alias{read_mle_gene_summary}
\title{Read and parse MAGeCK MLE output gene summary file}
\usage{
read_mle_gene_summary(filepath)
}
\arguments{
\item{filepath}{Path to the gene summary file output by \code{mageck mle}.}
}
\value{
A named list of data.frames containing MAGeCK MLE output,
one for each sample contained in the file.
}
\description{
This function reads the gene summary file output by \code{mageck mle} and
parses it into a list of data.frames, one for each sample. The sample names
are extracted from the column names of the input file and used as the names
of the list elements.
}
\examples{
library(CRISPRball)
mle_gene_summary <- file.path(system.file("extdata", "beta_leukemia.gene_summary.txt",
    package = "CRISPRball"
))
gene_data <- read_mle_gene_summary(mle_gene_summary)
}
\author{
Jared Andrews
}
