% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing_filtering_reduction.R
\name{exclude_features_scExp}
\alias{exclude_features_scExp}
\title{Remove specific features (CNA, repeats)}
\usage{
exclude_features_scExp(
  scExp,
  features_to_exclude,
  by = "region",
  verbose = TRUE
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object.}

\item{features_to_exclude}{A GenomicRanges object or data.frame containing
genomic regions or features to exclude or path towards a BED file containing
the features to exclude.}

\item{by}{Type of features. Either 'region' or 'feature_name'. If 'region',
will look for genomic coordinates in columns 1-3 (chr,start,stop).
If 'feature_name', will look for a genes in first column. ('region')}

\item{verbose}{(TRUE)}
}
\value{
A SingleCellExperiment object without features to exclude.
}
\description{
Remove specific features (CNA, repeats)
}
\examples{

raw <- create_scDataset_raw()
scExp = create_scExp(raw$mat, raw$annot)
features_to_exclude = data.frame(chr=c("chr4","chr7","chr17"),
start=c(50000,8000000,2000000),
end=c(100000,16000000,2500000))
features_to_exclude = as(features_to_exclude,"GRanges")
scExp = exclude_features_scExp(scExp,features_to_exclude)
scExp

}
