% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.CellBender.R
\name{DO.CellBender}
\alias{DO.CellBender}
\title{DO.CellBender}
\usage{
DO.CellBender(
  cellranger_path,
  output_path,
  samplenames = NULL,
  cuda = TRUE,
  cpu_threads = 15,
  epochs = 150,
  lr = 1e-05,
  estimator_multiple_cpu = FALSE,
  log = TRUE,
  conda_path = NULL,
  BarcodeRanking = TRUE,
  bash_script = system.file("bash", "_run_CellBender.sh", package = "DOtools")
)
}
\arguments{
\item{cellranger_path}{Path to folder with CellRanger outputs.}

\item{output_path}{Output directory for CellBender results.}

\item{samplenames}{Optional vector of sample names. If NULL, will
autodetect folders in \code{cellranger_path}.}

\item{cuda}{Logical, whether to use GPU (CUDA).}

\item{cpu_threads}{Number of CPU threads to use.}

\item{epochs}{Number of training epochs.}

\item{lr}{Learning rate.}

\item{estimator_multiple_cpu}{Use estimator with multiple CPU threads.}

\item{log}{Whether to enable logging.}

\item{conda_path}{Optional path to the conda environment.}

\item{BarcodeRanking}{Optional Calculation of estimated cells in samples
through DropletUtils implementation}

\item{bash_script}{Path to the bash script that runs CellBender.}
}
\value{
None
}
\description{
This function wraps a system call to a bash script for running
CellBender on CellRanger outputs. It ensures required inputs are available
and optionally installs CellBender in a conda env.
}
\examples{
\dontrun{
# Define paths
cellranger_path <- "/mnt/data/cellranger_outputs"
output_path <- "/mnt/data/cellbender_outputs"

# Optional: specify sample names if automatic detection is not desired
samplenames <- c("Sample_1", "Sample_2")

# Run CellBender (uses GPU by default)
DO.CellBender(
    cellranger_path = cellranger_path,
    output_path = output_path,
    samplenames = samplenames,
    cuda = TRUE,
    cpu_threads = 8,
    epochs = 100,
    lr = 0.00001,
    estimator_multiple_cpu = FALSE,
    log = TRUE
)
}

}
