% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNANetwork.R
\name{find_miRNA_targets}
\alias{find_miRNA_targets}
\title{The find_miRNA_targets function}
\usage{
find_miRNA_targets(
  EpiMixResults,
  geneExprData,
  database = "mirtarbase",
  raw.pvalue.threshold = 0.05,
  adjusted.pvalue.threshold = 0.2,
  cores = 1
)
}
\arguments{
\item{EpiMixResults}{List of the result objects returned from the EpiMix function.}

\item{geneExprData}{Matrix of the messenger RNA expression data with genes in rows and samples in columns.}

\item{database}{character string indicating the database for retrieving miRNA targets. Default: "mirtarbase".}

\item{raw.pvalue.threshold}{Numeric value indicating the threshold of the raw P value for selecting the miRNA targets based on gene expression. Default: 0.05.}

\item{adjusted.pvalue.threshold}{Numeric value indicating the threshold of the adjusted P value for selecting the miRNA targets based on gene expression. Default: 0.2.}

\item{cores}{Number of CPU cores to be used for computation. Default: 1.}
}
\value{
Matrix indicating the miRNA-target pairs, with fold changes of target gene expression and P values.
}
\description{
Detection potential target protein-coding genes for the differentially methylated miRNAs using messenger RNA expression data
}
\examples{
\donttest{
library(multiMiR)
library(miRBaseConverter)

data(mRNA.data)
data(Sample_EpiMixResults_miRNA)

miRNA_targets <- find_miRNA_targets(
 EpiMixResults = Sample_EpiMixResults_miRNA,
 geneExprData = mRNA.data
)
}

}
