### =========================================================================
### H5ADMatrix objects
### -------------------------------------------------------------------------
###


setClass("H5ADMatrix",
    contains="DelayedMatrix",
    representation(seed="H5ADMatrixSeed")
)


### - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
### Constructor
###

setMethod("DelayedArray", "H5ADMatrixSeed",
    function(seed) new_DelayedArray(seed, Class="H5ADMatrix")
)

### Works directly on an H5ADMatrixSeed derivative, in which case it must
### be called with a single argument.
H5ADMatrix <- function(filepath, layer=NULL)
{
    if (is(filepath, "H5ADMatrixSeed")) {
        if (!is.null(layer))
            stop(wmsg("H5ADMatrix() must be called with a single argument ",
                      "when passed an H5ADMatrixSeed derivative"))
        seed <- filepath
    } else {
        seed <- H5ADMatrixSeed(filepath, layer=layer)
    }
    DelayedArray(seed)
}


### - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
### Taking advantage of sparsity
###

### Will work only if the seed is an H5SparseMatrixSeed derivative, that is,
### if it's a CSC_H5ADMatrixSeed or CSR_H5ADMatrixSeed object.
setMethod("nzcount", "H5ADMatrix", function(x) nzcount(x@seed))

### Will work only if the seed is a CSC_H5ADMatrixSeed object.
setMethod("extractNonzeroDataByCol", "H5ADMatrix",
    function(x, j) extractNonzeroDataByCol(x@seed, j)
)

### Will work only if the seed is a CSR_H5ADMatrixSeed object.
setMethod("extractNonzeroDataByRow", "H5ADMatrix",
    function(x, i) extractNonzeroDataByCol(x@seed, i)
)

