% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_vcf_fields.R
\name{select_vcf_fields}
\alias{select_vcf_fields}
\title{Select VCF fields}
\usage{
select_vcf_fields(
  path,
  sampled_rows = 10000L,
  which = NULL,
  samples = NULL,
  nThread = 1,
  verbose = TRUE
)
}
\arguments{
\item{path}{Path to local or remote VCF file.}

\item{sampled_rows}{First N rows to sample.
Set \code{NULL} to use full \code{sumstats_file}.
when determining whether cols are empty.}

\item{which}{Genomic ranges to be added if supplied. Default is NULL.}

\item{samples}{Which samples to use:
\itemize{
\item{1 : }{Only the first sample will be used (\emph{DEFAULT}).}
\item{NULL : }{All samples will be used.}
\item{c("<sample_id1>","<sample_id2>",...) : }{
Only user-selected samples will be used (case-insensitive).}
}}

\item{nThread}{Number of threads to use for parallel processes.}

\item{verbose}{Print messages.}
}
\value{
\code{ScanVcfParam} object.
}
\description{
Select non-empty columns from each VCF field type.
}
\keyword{internal}
