% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{calc_scaling_vector}
\alias{calc_scaling_vector}
\title{Calculate scaling factor for a dataset}
\usage{
calc_scaling_vector(
  data,
  scaling_factor,
  custom_scaling_vector,
  scaling_factor_single_cell,
  BPPARAM,
  run_parallel
)
}
\arguments{
\item{data}{dataset object}

\item{scaling_factor}{name of scaling factor; possible are: \code{census}, \code{spike_in}, \code{read_number}, \code{custom} or \code{NONE} for no scaling factor}

\item{custom_scaling_vector}{named vector with custom scaling values for cell-types. Cell-types that do not occur in this vector but are present in the dataset will be set to 1}

\item{scaling_factor_single_cell}{boolean: decide if a scaling value for each single cell is calculated (default) or the median of all scaling values for each cell type is calculated}

\item{BPPARAM}{BiocParallel::bpparam() by default; if specific number of threads x want to be used, insert: BiocParallel::MulticoreParam(workers = x)}

\item{run_parallel}{boolean, decide if multi-threaded calculation will be run. FALSE by default}
}
\value{
a named vector with a scaling value for each cell in the dataset
}
\description{
Each scaling factor has a default matrix it will try to use (counts or TPM). If the required matrix is not available, the other one is used and a warning is given.
}
\keyword{internal}
