% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{dataset_sfaira_multiple}
\alias{dataset_sfaira_multiple}
\title{Build \link[SummarizedExperiment]{SummarizedExperiment} using multiple sfaira entries}
\usage{
dataset_sfaira_multiple(
  organisms = NULL,
  tissues = NULL,
  assays = NULL,
  sfaira_setup,
  name = "SimBu_dataset",
  spike_in_col = NULL,
  additional_cols = NULL,
  filter_genes = TRUE,
  variance_cutoff = 0,
  type_abundance_cutoff = 0,
  scale_tpm = TRUE
)
}
\arguments{
\item{organisms}{(mandatory) list of organisms (only human and mouse available)}

\item{tissues}{(mandatory) list of tissues}

\item{assays}{(mandatory) list of assays}

\item{sfaira_setup}{(mandatory) the sfaira setup; given by \code{\link{setup_sfaira}}}

\item{name}{name of the dataset; will be used for new unique IDs of cells}

\item{spike_in_col}{which column in annotation contains information on spike_in counts, which can be used to re-scale counts}

\item{additional_cols}{list of column names in annotation, that should be stored as well in dataset object}

\item{filter_genes}{boolean, if TRUE, removes all genes with 0 expression over all samples & genes with variance below \code{variance_cutoff}}

\item{variance_cutoff}{numeric, is only applied if \code{filter_genes} is TRUE: removes all genes with variance below the chosen cutoff}

\item{type_abundance_cutoff}{numeric, remove all cells, whose cell-type appears less then the given value. This removes low abundant cell-types}

\item{scale_tpm}{boolean, if TRUE (default) the cells in tpm_matrix will be scaled to sum up to 1e6}
}
\value{
dataset object
}
\description{
You can apply different filters on the whole data-zoo of sfaria; the resulting single-cell datasets will
be combined into a single dataset which you can use for simulation
Note: only datasets in sfaira with annotation are considered!
}
\examples{
\donttest{
setup_list <- SimBu::setup_sfaira(tempdir())
ds_human_lung <- SimBu::dataset_sfaira_multiple(
  sfaira_setup = setup_list,
  organisms = "Homo sapiens",
  tissues = "lung parenchyma",
  assay = "10x 3' v2",
  name = "human_lung"
)
}

}
