% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/33_survival.R
\name{.coxph}
\alias{.coxph}
\alias{.survdiff}
\alias{.logrank}
\title{Fit onefeature survival}
\usage{
.coxph(sd, formula)

.survdiff(sd, formula)

.logrank(sd, formula)
}
\arguments{
\item{sd}{data.table}

\item{formula}{model formula}
}
\description{
Fit onefeature survival
}
\examples{
# Dataset
     sd <- survobj()
     sd \%<>\% sumexp_to_longdt( svars = c('timetoevent', 'event', 'age', 'sex'), assay = 'exprs2levels')
     sd[, value := code(factor(value), 'code_control')]
     sd[,   age := code(factor(age  ), 'code_control')]
     sd[,   sex := code(factor(sex  ), 'code_control')]
     
# Singlefactor - coxph, survdiff, logrank
    .survdiff(sd, survival::Surv(timetoevent, event) ~ value)
     .logrank(sd, survival::Surv(timetoevent, event) ~ value)
       .coxph(sd, survival::Surv(timetoevent, event) ~ value)
       .coxph(sd, survival::Surv(timetoevent, event) ~ age/value)
}
