% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_contrastogram.R
\name{plot_contrastogram}
\alias{plot_contrastogram}
\title{Plot contrastogram}
\usage{
plot_contrastogram(
  object,
  subgroupvar,
  formula = as.formula(paste0("~ 0 +", subgroupvar)),
  colors = make_colors(slevels(object, subgroupvar), guess_sep(object)),
  curve = 0.1
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{subgroupvar}{subgroup svar}

\item{formula}{formula}

\item{colors}{named color vector (names = subgroups)}

\item{curve}{arrow curvature}
}
\value{
list returned by \code{\link[diagram]{plotmat}}
}
\description{
Plot contrastogram
}
\examples{
if (installed('diagram')){
   file <- download_data('halama18.metabolon.xlsx')
   object <- read_metabolon(file)
   plot_contrastogram(object, subgroupvar = 'subgroup')
}
}
