% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{adjustPValues}
\alias{adjustPValues}
\title{Adjust P-values for Multiple Comparisons}
\usage{
adjustPValues(p, method, n = length(p))
}
\arguments{
\item{p}{numeric vector of p-values (possibly with
    \code{\link{NA}}s).  Any other \R object is coerced by
    \code{\link{as.numeric}}.}

\item{method}{correction method.  Can be abbreviated.}

\item{n}{number of comparisons, must be at least \code{length(p)}; only set
this (to non-default) when you know what you are doing! Note that for
Bonferroni correction it is possible to specify number lower than
\code{length(p)}.}
}
\value{
A numeric vector of corrected p-values (of the same length as p, with
  names copied from p).
}
\description{
Given a set of p-values, returns p-values adjusted using one of several
methods.
}
\details{
This function modifies \code{stats::p.adjust} method such that for Bonferroni
correction it is possible to specify \code{n} lower than \code{length(p)}.
This feature is useful in cases when knowledge about the biology or
redundance of alleles reduces the need for correction.

See \code{\link[stats]{p.adjust}} for more details.
}
