% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformationFunctions.R
\name{countsToVariables}
\alias{countsToVariables}
\title{Convert counts table to variables}
\usage{
countsToVariables(counts, dictionary, na.value = NA, nacols.rm = TRUE)
}
\arguments{
\item{counts}{Data frame with counts, such as returned by
\code{\link{hlaCallsToCounts}} function. First column should contain
samples IDs, following columns should contain counts (natural numbers
including zero).}

\item{dictionary}{Path to file containing variables dictionary or data
frame. See details for further explanations.}

\item{na.value}{Vector of length one speciyfing value for variables with no
matching entry in \code{dictionary}. Default is to use \code{0}.}

\item{nacols.rm}{Logical indicating if result columns that contain only
\code{NA} should be removed.}
}
\value{
Data frame with variable number of columns. First column named 
  \code{"ID"} corresponds to \code{"ID"} column in \code{counts}, further
  columns hold indicators for converted variables. \code{1} and \code{0} 
  code presence and absence of a variable respectively.
}
\description{
\code{countsToVariables} converts counts table to additional variables.
}
\details{
\code{dictionary} file should be a tsv format with header and two columns.
First column should be named \code{"Name"} and hold variable name, second
should be named \code{"Expression"} and hold expression used to identify
variable (eg. \code{"KIR2DL3 & ! KIR2DL2"} will match all samples with
\code{KIR2DL3} and without \code{KIR2DL2}). Optionally a data frame formatted
in the same manner can be passed instead.

Dictionaries shipped with the package:
\describe{
  \item{\code{kir_haplotypes}}{
    KIR genes to KIR haplotypes dictionary.
  }
}
}
\examples{
countsToVariables(MiDAS_tut_KIR, "kir_haplotypes")

}
