% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summariseAAPosition}
\alias{summariseAAPosition}
\title{Summarize amino acid position}
\usage{
summariseAAPosition(hla_calls, aa_pos, aln = NULL, na.rm = FALSE)
}
\arguments{
\item{hla_calls}{HLA calls data frame, as returned by
\code{\link{readHlaCalls}} function.}

\item{aa_pos}{String specifying gene and amino acid position, example
\code{"A_9"}.}

\item{aln}{Matrix containing amino acid sequence alignments as returned by
\code{\link{readHlaAlignments}} function. By default function will use
alignment files shipped with the package.}

\item{na.rm}{Logical flag indicating if \code{NA} values should be considered
for frequency calculations.}
}
\value{
Data frame containing HLA alleles, their corresponding amino acid
  residues and frequencies at requested position.
}
\description{
List HLA alleles and amino acid residues at a given position.
}
\examples{
summariseAAPosition(MiDAS_tut_HLA, "A_9")

}
