% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_mgmt.R
\name{styleColorBar_divergent}
\alias{styleColorBar_divergent}
\title{Style DT color bars}
\usage{
styleColorBar_divergent(data, color_pos, color_neg)
}
\arguments{
\item{data}{The numeric vector whose range will be used for scaling the table
data from 0-100 before being represented as color bars. A vector of length 2
is acceptable here for specifying a range possibly wider or narrower than the
range of the table data itself.}

\item{color_pos}{The color of the bars for the positive values}

\item{color_neg}{The color of the bars for the negative values}
}
\value{
This function generates JavaScript and CSS code from the values
specified in R, to be used in DT tables formatting.
}
\description{
Style DT color bars for values that diverge from 0.
}
\details{
This function draws background color bars behind table cells in a column,
width the width of bars being proportional to the column values \emph{and} the color
dependent on the sign of the value.

A typical usage is for values such as \code{log2FoldChange} for tables resulting from
differential expression analysis.
Still, the functionality of this can be quickly generalized to other cases -
see in the examples.

The code of this function is heavily inspired from styleColorBar, and borrows
at full hands from an excellent post on StackOverflow -
https://stackoverflow.com/questions/33521828/stylecolorbar-center-and-shift-left-right-dependent-on-sign/33524422#33524422
}
\examples{

# With a very simple data frame

simplest_df <- data.frame(
  a = c(rep("a", 9)),
  value = c(-4, -3, -2, -1, 0, 1, 2, 3, 4)
)

library("DT")
DT::datatable(simplest_df) |>
  formatStyle(
    "value",
    background = styleColorBar_divergent(
      simplest_df$value,
      scales::alpha("forestgreen", 0.4),
      scales::alpha("gold", 0.4)
    ),
    backgroundSize = "100\% 90\%",
    backgroundRepeat = "no-repeat",
    backgroundPosition = "center"
  )
}
