% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R
\name{chromPeakChromatograms}
\alias{chromPeakChromatograms}
\alias{chromPeakChromatograms,XcmsExperiment-method}
\title{Extract an ion chromatogram for each chromatographic peak}
\usage{
chromPeakChromatograms(object, ...)

\S4method{chromPeakChromatograms}{XcmsExperiment}(
  object,
  expandRt = 0,
  expandMz = 0,
  aggregationFun = "max",
  peaks = character(),
  return.type = c("XChromatograms", "MChromatograms"),
  ...,
  progressbar = TRUE
)
}
\arguments{
\item{object}{An \code{\link[=XcmsExperiment]{XcmsExperiment()}} with identified chromatographic peaks.}

\item{...}{currently ignored.}

\item{expandRt}{\code{numeric(1)} to eventually expand the retention time range
from which the signal should be integrated. The chromatogram will
contain signal from \code{chromPeaks[, "rtmin"] - expandRt} to
\code{chromPeaks[, "rtmax"] + expandRt}. The default is \code{expandRt = 0}.}

\item{expandMz}{\code{numeric(1)} to eventually expand the m/z range
from which the signal should be integrated. The chromatogram will
contain signal from \code{chromPeaks[, "mzmin"] - expandMz} to
\code{chromPeaks[, "mzmax"] + expandMz}. The default is \code{expandMz = 0}.}

\item{aggregationFun}{\code{character(1)} defining the function how signals
within the m/z range in each spectrum (i.e. for each discrete retention
time) should be aggregated. The default (\code{aggregationFun = "max"})
reports the largest signal for each spectrum.}

\item{peaks}{optional \code{character} providing the IDs of the chromatographic
peaks (i.e. the row names of the peaks in \code{chromPeaks(object)}) for
which chromatograms should be returned.}

\item{return.type}{\code{character(1)} specifying the type of the returned object.
Can be either \code{return.type = "XChromatograms"} (the default) or
\code{return.type = "MChromatograms"} to return either a chromatographic
object with or without the identified chromatographic peaks,
respectively.}

\item{progressbar}{\code{logical(1)} whether the progress of the extraction
process should be displayed.}
}
\description{
Extract an ion chromatogram (EIC) for each chromatographic peak in an
\code{\link[=XcmsExperiment]{XcmsExperiment()}} object. The result is returned as an \code{\link[=XChromatograms]{XChromatograms()}}
of length equal to the number of chromatographic peaks (and one column).
}
\examples{

## Load a test data set with detected peaks
library(MSnbase)
library(xcms)
library(MsExperiment)
faahko_sub <- loadXcmsData("faahko_sub2")

## Get EICs for every detected chromatographic peak
chrs <- chromPeakChromatograms(faahko_sub)
chrs

## Order of EICs matches the order in chromPeaks
chromPeaks(faahko_sub) |> head()

## variable "sample_index" provides the index of the sample the EIC was
## extracted from
fData(chrs)$sample_index

## Get the EIC for selected peaks only.
pks <- rownames(chromPeaks(faahko_sub))[c(6, 12)]
pks

## Expand the data on retention time dimension by 15 seconds (on each side)
res <- chromPeakChromatograms(faahko_sub, peaks = pks, expandRt = 5)
plot(res[1, ])
}
\seealso{
\code{\link[=featureChromatograms]{featureChromatograms()}} to extract an EIC for each feature.
}
\author{
Johannes Rainer
}
