% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsExperiment.R, R/methods-OnDiskMSnExp.R
\name{estimatePrecursorIntensity,MsExperiment-method}
\alias{estimatePrecursorIntensity,MsExperiment-method}
\alias{estimatePrecursorIntensity,OnDiskMSnExp-method}
\title{Estimate precursor intensity for MS level 2 spectra}
\usage{
\S4method{estimatePrecursorIntensity}{MsExperiment}(
  object,
  ppm = 10,
  tolerance = 0,
  method = c("previous", "interpolation"),
  BPPARAM = bpparam()
)

\S4method{estimatePrecursorIntensity}{OnDiskMSnExp}(
  object,
  ppm = 10,
  tolerance = 0,
  method = c("previous", "interpolation"),
  BPPARAM = bpparam()
)
}
\arguments{
\item{object}{\code{MsExperiment}, \code{XcmsExperiment}, \code{OnDiskMSnExp} or
\code{XCMSnExp} object.}

\item{ppm}{\code{numeric(1)} defining the maximal acceptable difference (in ppm)
of the precursor m/z and the m/z of the corresponding peak in the MS 1
scan.}

\item{tolerance}{\code{numeric(1)} with the maximal allowed difference of m/z
values between the precursor m/z of a spectrum and the m/z of the
respective ion on the MS1 scan.}

\item{method}{\code{character(1)} defining the method how the precursor intensity
should be determined (see description above for details). Defaults to
\code{method = "previous"}.}

\item{BPPARAM}{parallel processing setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for
details.}
}
\value{
\code{numeric} with length equal to the number of spectra in \code{x}. \code{NA} is
returned for MS 1 spectra or if no matching peak in a MS 1 scan can be
found for an MS 2 spectrum
}
\description{
\code{estimatePrecursorIntensity()} determines the precursor intensity for a MS 2
spectrum based on the intensity of the respective signal from the
neighboring MS 1 spectra (i.e. based on the peak with the m/z matching the
precursor m/z of the MS 2 spectrum). Based on parameter \code{method} either the
intensity of the peak from the previous MS 1 scan is used
(\code{method = "previous"}) or an interpolation between the intensity from the
previous and subsequent MS1 scan is used (\code{method = "interpolation"}, which
considers also the retention times of the two MS1 scans and the retention
time of the MS2 spectrum).
}
\author{
Johannes Rainer with feedback and suggestions from Corey Broeckling
}
