% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-OnDiskMSnExp.R, R/methods-XCMSnExp.R
\name{extractMsData,OnDiskMSnExp-method}
\alias{extractMsData,OnDiskMSnExp-method}
\alias{extractMsData,XCMSnExp-method}
\alias{extractMsData}
\title{DEPRECATED: Extract a \code{data.frame} containing MS data}
\usage{
\S4method{extractMsData}{OnDiskMSnExp}(object, rt, mz, msLevel = 1L)

\S4method{extractMsData}{XCMSnExp}(
  object,
  rt,
  mz,
  msLevel = 1L,
  adjustedRtime = hasAdjustedRtime(object)
)
}
\arguments{
\item{object}{A \code{XCMSnExp} or \code{OnDiskMSnExp} object.}

\item{rt}{\code{numeric(2)} with the retention time range from which the
data should be extracted.}

\item{mz}{\code{numeric(2)} with the mz range.}

\item{msLevel}{\code{integer} defining the MS level(s) to which the data
should be sub-setted prior to extraction; defaults to
\code{msLevel = 1L}.}

\item{adjustedRtime}{(for \verb{extractMsData,XCMSnExp}): \code{logical(1)}
specifying if adjusted or raw retention times should be reported.
Defaults to adjusted retention times, if these are present in
\code{object}.}
}
\value{
A \code{list} of length equal to the number of samples/files in
\code{object}. Each element being a \code{data.frame} with columns
\code{"rt"}, \code{"mz"} and \code{"i"} with the retention time, mz and
intensity tuples of a file. If no data is available for the mz-rt range
in a file a \code{data.frame} with 0 rows is returned for that file.
}
\description{
\strong{UPDATE}: the \code{extractMsData} and \code{plotMsData} functions are deprecated
and \code{as(x, "data.frame")} and \code{plot(x, type = "XIC")} (\code{x} being an
\code{OnDiskMSnExp} or \code{XCMSnExp} object) should be used instead. See examples
below. Be aware that filtering the raw object might however drop the
adjusted retention times. In such cases it is advisable to use the
\code{\link[=applyAdjustedRtime]{applyAdjustedRtime()}} function prior to filtering.

Extract a \code{data.frame} of retention time, mz and intensity
values from each file/sample in the provided rt-mz range (or for the full
data range if \code{rt} and \code{mz} are not defined).
}
\examples{

## Load a test data set with detected peaks
library(MSnbase)
data(faahko_sub)
## Update the path to the files for the local system
dirname(faahko_sub) <- system.file("cdf/KO", package = "faahKO")

## Disable parallel processing for this example
register(SerialParam())

## Extract the full MS data for a certain retention time range
## as a data.frame
tmp <- filterRt(faahko_sub, rt = c(2800, 2900))
ms_all <- as(tmp, "data.frame")
head(ms_all)
nrow(ms_all)
}
\seealso{
\code{XCMSnExp} for the data object.
}
\author{
Johannes Rainer
}
