% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XcmsExperiment-plotting.R
\name{plotChromPeaks}
\alias{plotChromPeaks}
\alias{plotChromPeakImage}
\title{General visualizations of peak detection results}
\usage{
plotChromPeaks(
  x,
  file = 1,
  xlim = NULL,
  ylim = NULL,
  add = FALSE,
  border = "#00000060",
  col = NA,
  xlab = "retention time",
  ylab = "mz",
  main = NULL,
  msLevel = 1L,
  ...
)

plotChromPeakImage(
  x,
  binSize = 30,
  xlim = NULL,
  log = FALSE,
  xlab = "retention time",
  yaxt = par("yaxt"),
  main = "Chromatographic peak counts",
  msLevel = 1L,
  ...
)
}
\arguments{
\item{x}{A \code{\link[=XcmsExperiment]{XcmsExperiment()}} or \code{\link[=XCMSnExp]{XCMSnExp()}} object.}

\item{file}{For \code{plotChromPeaks}: \code{integer(1)} specifying the
index of the file within \code{x} for which the plot should be created.
Defaults to \code{file = 1}.}

\item{xlim}{\code{numeric(2)} specifying the x-axis limits (retention time
dimension). Defaults to \code{xlim = NULL} in which case the full retention
time range of the file is used.}

\item{ylim}{For \code{plotChromPeaks}: \code{numeric(2)} specifying the
y-axis limits (m/z dimension). Defaults to \code{ylim = NULL} in which
case the full m/z range of the file is used.}

\item{add}{For \code{plotChromPeaks}: \code{logical(1)} whether the plot
should be added to an existing plot or if a new plot should be created.}

\item{border}{For \code{plotChromPeaks}: the color for the rectangles'
border.}

\item{col}{For \code{plotChromPeaks}: the color to be used to fill the
rectangles.}

\item{xlab}{\code{character(1)} defining the x-axis label.}

\item{ylab}{For \code{plotChromPeaks}: \code{character(1)} defining the
y-axis label.}

\item{main}{\code{character(1)} defining the plot title. By default (i.e.
\code{main = NULL}) the name of the file will be used as title.}

\item{msLevel}{\code{integer(1)} defining the MS level from which the peaks
should be visualized.}

\item{...}{Additional arguments passed to the \code{plot} (for
\code{plotChromPeaks}) and \code{image} (for
\code{plotChromPeakImage}) functions. Ignored for \code{add = TRUE}.}

\item{binSize}{For \code{plotChromPeakImage}: \code{numeric(1)} defining the
size of the bins along the x-axis (retention time). Defaults to
\code{binSize = 30}, peaks within each 30 seconds will thus counted and
plotted.}

\item{log}{For \code{plotChromPeakImage}: \code{logical(1)} whether the peak
counts should be log2 transformed before plotting.}

\item{yaxt}{For \code{plotChromPeakImage}: \code{character(1)} defining
whether y-axis labels should be added. To disable the y-axis use
\code{yaxt = "n"}. For any other value of \code{yaxt} the axis will be
drawn. See \code{\link[=par]{par()}} help page for more details.}
}
\description{
\code{plotChromPeaks} plots the identified chromatographic
peaks from one file into the plane spanned by the retention time (x-axis)
and m/z (y-axis) dimension. Each chromatographic peak is plotted as a
rectangle representing its width in RT and m/z dimension.

\code{plotChromPeakImage} plots the number of detected peaks for
each sample along the retention time axis as an \emph{image} plot, i.e.
with the number of peaks detected in each bin along the retention time
represented with the color of the respective cell.
}
\details{
The width and line type of the rectangles indicating the detected
chromatographic peaks for the \code{plotChromPeaks} function can be
specified using the \code{par} function, i.e. with \code{par(lwd = 3)}
and \code{par(lty = 2)}, respectively.
}
\examples{

## Load a test data set with detected peaks
faahko_sub <- loadXcmsData("faahko_sub2")

## plotChromPeakImage: plot an image for the identified peaks per file
plotChromPeakImage(faahko_sub)

## Show all detected chromatographic peaks from the first file
plotChromPeaks(faahko_sub)

## Plot all detected peaks from the second file and restrict the plot to a
## mz-rt slice
plotChromPeaks(faahko_sub, file = 2, xlim = c(3500, 3600), ylim = c(400, 600))
}
\author{
Johannes Rainer
}
