% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XcmsExperiment-plotting.R
\name{plotPrecursorIons}
\alias{plotPrecursorIons}
\title{General visualization of precursor ions of LC-MS/MS data}
\usage{
plotPrecursorIons(
  x,
  pch = 21,
  col = "#00000080",
  bg = "#00000020",
  xlab = "retention time",
  ylab = "m/z",
  main = character(),
  ...
)
}
\arguments{
\item{x}{\code{MsExperiment} of LC-MS/MS data.}

\item{pch}{\code{integer(1)} defining the symbol/point type to be used to draw
points. See \code{\link[=points]{points()}} for details. Defaults to \code{pch = 21} which allows
defining the background and border color for points.}

\item{col}{the color to be used for all data points. Defines the border
color if \code{pch = 21}.}

\item{bg}{the background color (if \code{pch = 21}).}

\item{xlab}{\code{character(1)} defining the x-axis label.}

\item{ylab}{\code{character(1)} defining the y-axis label.}

\item{main}{Optional \code{character(1)} with the title for \strong{every} plot. If
not provided (the default) the base file name will be used for each
sample.}

\item{...}{additional parameters to be passed to the \code{plot} calls.}
}
\description{
Simple visualization of the position of fragment spectra's precursor ion
in the MS1 retention time by m/z area.
}
\examples{

## Load a test data file with DDA LC-MS/MS data
library(MsExperiment)
fl <- system.file("TripleTOF-SWATH", "PestMix1_DDA.mzML", package = "msdata")
pest_dda <- readMsExperiment(fl)

plotPrecursorIons(pest_dda)
grid()

## Subset the data object to plot the data specifically for one or
## selected file/sample:
plotPrecursorIons(pest_dda[1L])
}
\author{
Johannes Rainer
}
