% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnData2SCE.R, R/SCE2AnnData.R
\name{AnnData-Conversion}
\alias{AnnData-Conversion}
\alias{AnnData2SCE}
\alias{SCE2AnnData}
\title{Convert between AnnData and SingleCellExperiment}
\usage{
AnnData2SCE(
  adata,
  X_name = NULL,
  layers = TRUE,
  uns = TRUE,
  var = TRUE,
  obs = TRUE,
  varm = TRUE,
  obsm = TRUE,
  varp = TRUE,
  obsp = TRUE,
  raw = FALSE,
  skip_assays = FALSE,
  hdf5_backed = TRUE,
  verbose = NULL
)

SCE2AnnData(
  sce,
  X_name = NULL,
  assays = TRUE,
  colData = TRUE,
  rowData = TRUE,
  varm = TRUE,
  reducedDims = TRUE,
  metadata = TRUE,
  colPairs = TRUE,
  rowPairs = TRUE,
  skip_assays = FALSE,
  verbose = NULL
)
}
\arguments{
\item{adata}{A \strong{reticulate} reference to a Python AnnData object.}

\item{X_name}{For \code{SCE2AnnData()} name of the assay to use as the primary
matrix (\code{X}) of the AnnData object. If \code{NULL}, the first assay of \code{sce} will
be used by default. For \code{AnnData2SCE()} name used when saving \code{X} as an
assay. If \code{NULL} looks for an \code{X_name} value in \code{uns}, otherwise uses \code{"X"}.}

\item{layers, uns, var, obs, varm, obsm, varp, obsp, raw}{Arguments specifying how
these slots are converted. If \code{TRUE} everything in that slot is converted, if
\code{FALSE} nothing is converted and if a character vector only those items or
columns are converted.}

\item{skip_assays}{Logical scalar indicating whether to skip conversion of
any assays in \code{sce} or \code{adata}, replacing them with empty sparse matrices
instead.}

\item{hdf5_backed}{Logical scalar indicating whether HDF5-backed matrices
in \code{adata} should be represented as HDF5Array objects. This assumes that
\code{adata} is created with \code{backed="r"}.}

\item{verbose}{Logical scalar indicating whether to print progress messages.
If \code{NULL} uses \code{getOption("zellkonverter.verbose")}.}

\item{sce}{A \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} object.}

\item{assays, colData, rowData, reducedDims, metadata, colPairs, rowPairs}{Arguments specifying how these slots are converted. If \code{TRUE} everything in
that slot is converted, if \code{FALSE} nothing is converted and if a character
vector only those items or columns are converted.}
}
\value{
\code{AnnData2SCE()} will return a
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} containing the equivalent data
from \code{adata}.

\code{SCE2AnnData()} will return a \strong{reticulate} reference to an AnnData object
containing the content of \code{sce}.
}
\description{
Conversion between Python AnnData objects and
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} objects.
}
\details{
\subsection{Python environment}{

These functions assume that an appropriate Python environment has already
been loaded. As such, they are largely intended for developer use, most
typically inside a \strong{basilisk} context.
}

\subsection{Conversion mapping}{

The conversion is not entirely lossless. The current mapping is shown below
(also at \url{https://tinyurl.com/AnnData2SCE}):

\if{html}{
    \figure{AnnData2SCE.png}{options: width=800, alt="SCE-AnnData map"}
}
\if{latex}{\figure{AnnData2SCE.png}{options: width=5in}}
}

\subsection{Matrix conversion}{

In \code{SCE2AnnData()}, matrices are converted to a \strong{numpy}-friendly format.
Sparse matrices are converted to \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}
objects while all other matrices are converted into ordinary matrices. If
\code{skip_assays = TRUE}, empty sparse matrices are created instead and the user
is expected to fill in the assays on the Python side.

For \code{AnnData2SCE()}, a warning is raised if there is no corresponding R
format for a matrix in the \code{AnnData} object, and an empty sparse matrix is
created instead as a placeholder. If \code{skip_assays = NA}, no warning is
emitted but variables are created in the
\code{\link[SingleCellExperiment:internals]{int_metadata}} of the
output to specify which assays were skipped.

If \code{skip_assays = TRUE}, empty sparse matrices are created for all assays,
regardless of whether they might be convertible to an R format or not.
In both cases, the user is expected to fill in the assays on the R side.
}

\subsection{\code{metadata}/\code{uns} conversion}{

We attempt to convert between items in the
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}
\code{\link[S4Vectors:Annotated-class]{metadata()}} slot and the \code{AnnData} \code{uns} slot. If
an item cannot be converted a warning will be raised.
}

\subsection{\code{varm} conversion}{

Values stored in the \code{varm} slot of an \code{AnnData} object are stored in a
column of \code{\link[SummarizedExperiment:SummarizedExperiment-class]{rowData()}} in a
\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} as a
\code{\link[S4Vectors:DataFrame-class]{DataFrame}} of matrices. If this column is
present an attempt is made to transfer this information when converting
from \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} to \code{AnnData}.
}

\subsection{\code{SpatialExperiment} conversion}{

In \code{SCE2AnnData()}, if \code{sce} is a \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment::SpatialExperiment}
object, the spatial coordinates are added to the \code{reducedDims} slot before
conversion to an \code{AnnData} object.
}
}
\examples{
if (requireNamespace("scRNAseq", quietly = TRUE)) {
    library(basilisk)
    library(scRNAseq)
    seger <- SegerstolpePancreasData()

    # These functions are designed to be run inside
    # a specified Python environment
    roundtrip <- basiliskRun(fun = function(sce) {
        # Convert SCE to AnnData:
        adata <- zellkonverter::SCE2AnnData(sce)

        # Maybe do some work in Python on 'adata':
        # BLAH BLAH BLAH

        # Convert back to an SCE:
        zellkonverter::AnnData2SCE(adata)
    }, env = zellkonverterAnnDataEnv(), sce = seger)
}
}
\seealso{
\code{\link[=writeH5AD]{writeH5AD()}} and \code{\link[=readH5AD]{readH5AD()}} for dealing directly with H5AD files.
}
\author{
Luke Zappia

Aaron Lun
}
