% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_depmap.R
\name{plot_depmap_lineages}
\alias{plot_depmap_lineages}
\title{Plot selected information across lineages from DepMap.}
\usage{
plot_depmap_lineages(
  df,
  plot.val,
  group.by,
  lineage = NULL,
  depline = TRUE,
  label.size = 12,
  pt.size = 5,
  pt.color = "#56B4E9",
  boxplot.fill = "#E2E2E2",
  boxplot.line.color = "#000000"
)
}
\arguments{
\item{df}{data.frame containing information for a single gene
as returned by \code{\link{get_depmap_plot_data}}.}

\item{plot.val}{Character scalar of column name to plot values from.}

\item{group.by}{Character scalar of column name to group by.}

\item{lineage}{Character scalar of lineage for which
to plot sub-lineage data.}

\item{depline}{Boolean indicating whether to show the dependency threshold line.}

\item{label.size}{Numeric scaler for axis label size.}

\item{pt.size}{Numeric scalar for point size.}

\item{pt.color}{Character scalar for point color.}

\item{boxplot.fill}{Character scalar for boxplot fill color.}

\item{boxplot.line.color}{Character scalar for boxplot line color.}
}
\value{
plotly object
}
\description{
Plot selected information across lineages from DepMap.
}
\examples{
library(CRISPRball)
data("depmap_22q1_rnai")
plot_depmap_lineages(df = depmap_22q1_rnai, plot.val = "dependency", group.by = "lineage")
}
\seealso{
\code{\link{get_depmap_plot_data}}
}
\author{
Jared Andrews
}
