% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_qc.R
\name{plot_pca_biplot}
\alias{plot_pca_biplot}
\title{Plot a biplot from a PCAtools \code{pca} object}
\usage{
plot_pca_biplot(
  pca.res,
  dim.x = "PC1",
  dim.y = "PC2",
  dim.z = NULL,
  plot.title = "PCA Biplot",
  color.by = NULL,
  shape.by = NULL,
  hover.info = NULL,
  show.loadings = FALSE,
  n.loadings = 3,
  pt.size = 12
)
}
\arguments{
\item{pca.res}{A \code{\link[PCAtools]{pca}} generated by the PCAtools package.}

\item{dim.x}{Character scalar for the principal component to plot on the x-axis.}

\item{dim.y}{Character scalar for the principal component to plot on the y-axis.}

\item{dim.z}{Character scalar for the principal component to plot on the z-axis.}

\item{plot.title}{Character scalar for the title of the plot.}

\item{color.by}{Character scalar for the column name to use for coloring points.}

\item{shape.by}{Character scalar for the column name to use for shaping points.}

\item{hover.info}{Character vector of column name(s) to include in the hover info for each point.}

\item{show.loadings}{Boolean indicating whether to show component loadings on the plot.}

\item{n.loadings}{Integer for number of loadings to show.}

\item{pt.size}{Numeric size of the plotted points.}
}
\value{
A plotly plot of the PCA biplot, or a text grob indicating no PCA was provided.
}
\description{
This function plots a biplot from a PCAtools \code{\link[PCAtools]{pca}} object.
}
\examples{
library("PCAtools")
library("CRISPRball")
col <- 10
row <- 2000
mat <- matrix(
    rexp(col * row, rate = 0.1),
    ncol = col
)
rownames(mat) <- paste0("gene", seq_len(nrow(mat)))
colnames(mat) <- paste0("sample", seq_len(ncol(mat)))

metadata <- data.frame(row.names = colnames(mat))
metadata$Group <- rep(NA, ncol(mat))
metadata$Group[seq(1, 10, 2)] <- "A"
metadata$Group[seq(2, 10, 2)] <- "B"

p <- pca(mat, metadata = metadata, removeVar = 0.1)
plot_pca_biplot(p, color.by = "Group")
}
\seealso{
\code{\link[PCAtools]{pca}}
}
\author{
Jared Andrews
}
