% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_filtering_clustering.R
\name{find_clusters_louvain_scExp}
\alias{find_clusters_louvain_scExp}
\title{Build SNN graph and find cluster using Louvain Algorithm}
\usage{
find_clusters_louvain_scExp(
  scExp,
  k = 10,
  resolution = 1,
  use.dimred = "PCA",
  type = c("rank", "number", "jaccard")[3],
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{scExp}{A SingleCellExperiment with PCA calculated}

\item{k}{An integer scalar specifying the number of nearest neighbors to
consider during graph construction.}

\item{resolution}{A numeric specifying the resolution of clustering to pass to
igraph::cluster_louvain function.}

\item{use.dimred}{A string specifying the dimensionality reduction to use.}

\item{type}{A string specifying the type of weighting scheme to use for
shared neighbors.}

\item{BPPARAM}{BPPARAM object for multiprocessing. See
\link[BiocParallel]{bpparam} for more informations. Will take the default
BPPARAM set in your R session.}
}
\value{
A SingleCellExperiment containing the vector of clusters
(named C1, C2 ....)
}
\description{
Build SNN graph and find cluster using Louvain Algorithm
}
\examples{
data('scExp')

scExp = find_clusters_louvain_scExp(scExp, k = 10)
}
