% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_ref_genome_data.R
\name{load_ref_genome_data}
\alias{load_ref_genome_data}
\title{Load the reference genome data for SNPs of interest}
\source{
\code{
sumstats_dt <- formatted_example()
rsids <- MungeSumstats:::load_ref_genome_data(snps = sumstats_dt$SNP,
                                              ref_genome = "GRCH37",
                                              dbSNP=144)
}
}
\usage{
load_ref_genome_data(
  snps,
  ref_genome,
  dbSNP = c(144, 155),
  dbSNP_tarball = NULL,
  msg = NULL,
  chr_filt = NULL
)
}
\arguments{
\item{snps}{Character vector SNPs by rs_id from sumstats file of interest.}

\item{ref_genome}{Name of the reference genome used for the GWAS
(GRCh37 or GRCh38)}

\item{dbSNP}{version of dbSNP to be used (144 or 155)}

\item{dbSNP_tarball}{Pass local versions of dbSNP in tarball format. Default
of NULL uses the dbSNP version passed in \code{dbSNP} parmeter. \code{dbSNP_tarball}
was enabled to help with dbSNP versions >=156, after the decision to no
longer provide dbSNP releases as bioconductor packages. dbSNP 156 tarball is
available here: http://149.165.171.124/SNPlocs/.}

\item{msg}{Optional name of the column missing from the dataset in question.
Default is NULL}

\item{chr_filt}{Internal for testing - filter reference genomes and sumstats
to specific chromosomes for testing. Pass a list of chroms in format:
c("1","2"). Default is NULL i.e. no filtering.}
}
\value{
data table of snpsById, filtered to SNPs of interest.
}
\description{
Load the reference genome data for SNPs of interest
}
