% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21_pca.R
\name{biplot}
\alias{biplot}
\title{Biplot}
\usage{
biplot(
  object,
  method = biplot_methods(object)[1],
  by = biplot_by(object, method)[1],
  dims = biplot_dims(object, method, by)[1:2],
  color = if (method \%in\% DIMREDSUPER) by else "subgroup",
  labelcolors = FALSE,
  shape = NULL,
  size = NULL,
  alpha = NULL,
  group = NULL,
  linetype = NULL,
  label = NULL,
  feature_label = "feature_id",
  fixed = list(shape = 15, size = 3),
  nx = 0,
  ny = 0,
  colorpalette = make_svar_palette(object, color),
  alphapalette = make_alpha_palette(object, alpha),
  title = paste0(method, "~", by),
  theme = ggplot2::theme(plot.title = element_text(hjust = 0.5), panel.grid =
    element_blank())
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{method}{'pca', 'pls', 'lda', 'spls', 'opls', 'sma'}

\item{by}{svar}

\item{dims}{numeric vector: e.g. 1:2}

\item{color}{svar}

\item{labelcolors}{TRUE or FALSE}

\item{shape}{svar}

\item{size}{svar}

\item{alpha}{svar}

\item{group}{svar}

\item{linetype}{svar}

\item{label}{svar}

\item{feature_label}{fvar}

\item{fixed}{fixed plot aesthetics}

\item{nx}{number of x features to plot}

\item{ny}{number of y features to plot}

\item{colorpalette}{character vector}

\item{alphapalette}{character vector}

\item{title}{string}

\item{theme}{ggplot2::theme output}
}
\value{
ggplot object
}
\description{
Biplot
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% pca(ndim = 4)
object \%<>\% pls(ndim = 4)
biplot(object)
biplot(object, nx = 1)
biplot(object, dims = 3:4, nx = 1)
biplot(object, method = 'pls')
biplot(object, method = 'pls', dims = 3:4)
biplot(object, method = 'pls', dims = 3:4, group = 'Subject')
}
