% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_read_rnaseq.R
\name{counts2cpm}
\alias{counts2cpm}
\alias{cpm2counts}
\title{Convert between counts and cpm/tpm}
\usage{
counts2cpm(x, libsize = scaledlibsizes(x))

cpm2counts(x, libsize)
}
\arguments{
\item{x}{count/cpm matrix}

\item{libsize}{(scaled) libsize vector}
}
\value{
cpm/tpm/count matrix
}
\description{
Convert between counts and cpm/tpm
}
\examples{
file <- system.file('extdata/billing19.rnacounts.txt', package = 'autonomics')
object <- read_rnaseq_counts(file)
libsize <- scaledlibsizes(counts(object))
tpm <- counts2tpm(counts(object), genesize = 1)
cpm <- counts2cpm(counts(object), libsize)
counts  <- cpm2counts(cpm, libsize)
sum(counts(object) - counts)
}
