% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/24_linmod.R
\name{fits}
\alias{fits}
\alias{fits.data.table}
\alias{fits.SummarizedExperiment}
\alias{fits.NULL}
\alias{coefs}
\alias{coefs.factor}
\alias{coefs.data.table}
\alias{coefs.SummarizedExperiment}
\alias{coefs.NULL}
\alias{fitcoefs}
\title{Get fit models}
\usage{
fits(object, ...)

\method{fits}{data.table}(object, ...)

\method{fits}{SummarizedExperiment}(object, ...)

\method{fits}{`NULL`}(object, ...)

coefs(object, ...)

\method{coefs}{factor}(object, intercept = FALSE, ...)

\method{coefs}{data.table}(object, fit = fits(object), intercept = FALSE, ...)

\method{coefs}{SummarizedExperiment}(object, fit = fits(object), intercept = FALSE, ...)

\method{coefs}{`NULL`}(object, ...)

fitcoefs(object)
}
\arguments{
\item{object}{SummarizedExperiment or data.table}

\item{...}{S3 dispatch}

\item{intercept}{TRUE or FALSE : whether to include the intercept}

\item{fit}{'limma', 'lm', 'lme', 'lmer', 'wilcoxon'}
}
\value{
character vector
}
\description{
Get fit models
}
\examples{
object <- survobj()
object \%<>\% linmod_limma(~sex+age)
fits(object)
coefs(object)                                    # sumexp
coefs(fdt(object))                               # data.table
coefs(code(factor(object$age), 'code_control'))  # factor
fitcoefs(object)
}
