% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_read_omics.R
\name{merge_sample_file}
\alias{merge_sample_file}
\alias{merge_ffile}
\title{Merge sample / feature file}
\usage{
merge_sample_file(
  object,
  sfile = NULL,
  by.x = "sample_id",
  by.y = "sample_id",
  all.x = TRUE,
  select = NULL,
  stringsAsFactors = FALSE,
  verbose = TRUE
)

merge_ffile(
  object,
  ffile = NULL,
  by.x = "feature_id",
  by.y = "feature_id",
  all.x = TRUE,
  select = NULL,
  stringsAsFactors = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{sfile}{string       : sample file path}

\item{by.x}{string       : object mergevar}

\item{by.y}{string       : file mergevvar}

\item{all.x}{TRUE / FALSE : whether to keep samples / feature without annotation}

\item{select}{character    : [sf]file columns to select}

\item{stringsAsFactors}{TRUE / FALSE}

\item{verbose}{TRUE / FALSE}

\item{ffile}{string       : ffile path}
}
\value{
SummarizedExperiment
}
\description{
Merge sample / feature file
}
\examples{
file <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
subgroups <-  c('E00','E01', 'E02','E05','E15','E30', 'M00')
subgroups \%<>\% paste0('_STD')
object <- read_maxquant_proteingroups(file, subgroups = subgroups)
sfile <- paste0(tempdir(),'/', basename(tools::file_path_sans_ext(file)))
sfile \%<>\% paste0('.samples.txt')
dt <- data.table(sample_id = object$sample_id, 
                 day = split_extract_fixed(object$subgroup, '_', 1))
data.table::fwrite(dt, sfile)                 
sdt(object)
sdt(merge_sample_file(object, sfile))
}
