% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_read_diann.R
\name{.read_diann_precursors}
\alias{.read_diann_precursors}
\alias{.read_diann_proteingroups}
\alias{read_diann_proteingroups}
\alias{read_diann}
\title{Read diann}
\usage{
.read_diann_precursors(
  file,
  Global.Q = 0.01,
  Q = 0.01,
  Global.PG.Q = 0.01,
  PG.Q = 0.05,
  Global.Peptidoform.Q = 0.01,
  Peptidoform.Q = 0.01,
  Lib.Q = 0.01,
  Lib.PG.Q = 0.01,
  Lib.Peptidoform.Q = 0.01,
  verbose = TRUE
)

.read_diann_proteingroups(
  file,
  Global.Q = 0.01,
  Q = 0.01,
  Global.PG.Q = 0.01,
  PG.Q = 0.05,
  Global.Peptidoform.Q = 0.01,
  Peptidoform.Q = 0.01,
  Lib.Q = 0.01,
  Lib.PG.Q = 0.01,
  Lib.Peptidoform.Q = 0.01,
  verbose = TRUE
)

read_diann_proteingroups(
  file,
  Global.Q = 0.01,
  Q = 0.01,
  Global.PG.Q = 0.01,
  PG.Q = 0.05,
  Global.Peptidoform.Q = 0.01,
  Peptidoform.Q = 0.01,
  Lib.Q = 0.01,
  Lib.PG.Q = 0.01,
  Lib.Peptidoform.Q = 0.01,
  simplify_snames = TRUE,
  rm_contaminants = TRUE,
  impute = FALSE,
  plot = FALSE,
  pca = plot,
  pls = plot,
  fit = if (plot) "limma" else NULL,
  formula = ~subgroup,
  block = NULL,
  coefs = NULL,
  contrasts = NULL,
  palette = NULL,
  verbose = TRUE
)

read_diann(...)
}
\arguments{
\item{file}{DIA-NN report file (tsv or parquet)}

\item{Global.Q}{Global.Q cutoff}

\item{Q}{Q cutoff}

\item{Global.PG.Q}{Global.PG.Q cutoff}

\item{PG.Q}{PG.Q cutoff}

\item{Global.Peptidoform.Q}{Global.Peptidoform.Q cutoff}

\item{Peptidoform.Q}{Peptidoform.Q cutoff}

\item{Lib.Q}{Lib.Q cutoff}

\item{Lib.PG.Q}{Lib.PG.Q cutoff}

\item{Lib.Peptidoform.Q}{Lib.Peptidoform.Q cutoff}

\item{verbose}{TRUE or FALSE}

\item{simplify_snames}{TRUE or FALSE: simplify (drop common parts in) samplenames ?}

\item{rm_contaminants}{TRUE or FALSE: rm contaminants ?}

\item{impute}{TRUE or FALSE: impute group-specific NA values ?}

\item{plot}{TRUE or FALSE}

\item{pca}{TRUE or FALSE: run pca ?}

\item{pls}{TRUE or FALSE: run pls ?}

\item{fit}{model engine: 'limma', 'lm', 'lme(r)', 'wilcoxon' or NULL}

\item{formula}{model formula}

\item{block}{model blockvar: string or NULL}

\item{coefs}{model coefficients    of interest: character vector or NULL}

\item{contrasts}{coefficient contrasts of interest: character vector or NULL}

\item{palette}{color palette: named string vector}

\item{...}{used to maintain deprecated functions}
}
\value{
data.table or SummarizedExperiment
}
\description{
Read diann
}
\details{
Defaults for various Q value cutoffs corresppond to recommendations by the
DIA-NN teen for DIA-NN v.2 (as of 03.2025). Of these, the reader of the
legacy file format (flat tab seperated values, pre-DIA-NN v.2) only utilizes
Lib.PG.Q.
}
\examples{
# Read
   file <- download_data('dilution.report.tsv')
   .read_diann_precursors(file)         #    precursors longdt
   .read_diann_proteingroups(file)      # proteingroups longdt
   fdt(read_diann_proteingroups(file))  # proteingroups sumexp
# Compare
    PR <- .read_diann_precursors(file)
    PG <- .read_diann_proteingroups(file)
    PG[intensity==top1] # matches      : 24975 (85\%) proteingroups
    PG[intensity!=top1] # doesnt match :  4531 (15\%) proteingroups
    RUN <- 'IPT_HeLa_1_DIAstd_Slot1-40_1_9997'
    PR[uniprot=='Q96JP5;Q96JP5-2' & run == RUN, 1:6] #    match:    8884 ==   8884
    PR[uniprot=='P36578'          & run == RUN, 1:6] # no match:  650887 != 407978
    PR[intensity != top1][feature_id == unique(feature_id)[1]][run == unique(run)[1]][1:2, 1:6]
    PR[intensity != top1][feature_id == unique(feature_id)[2]][run == unique(run)[1]][1:2, 1:6]
    PR[intensity != top1][feature_id == unique(feature_id)[3]][run == unique(run)[1]][1:3, 1:6]
}
