% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsec.R
\name{RSEC}
\alias{RSEC}
\alias{RSEC-methods}
\alias{RSEC,ClusterExperiment-method}
\alias{RSEC,matrix-method}
\alias{RSEC,SingleCellExperiment-method}
\alias{RSEC,SummarizedExperiment-method}
\alias{RSEC,data.frame-method}
\alias{RSEC,matrixOrHDF5-method}
\title{Resampling-based Sequential Ensemble Clustering}
\usage{
\S4method{RSEC}{SummarizedExperiment}(x, ...)

\S4method{RSEC}{data.frame}(x, ...)

\S4method{RSEC}{ClusterExperiment}(x, eraseOld = FALSE, rerunClusterMany = FALSE, ...)

\S4method{RSEC}{matrixOrHDF5}(x, ...)

\S4method{RSEC}{SingleCellExperiment}(
  x,
  isCount = FALSE,
  transFun = NULL,
  reduceMethod = "PCA",
  nFilterDims = defaultNDims(x, reduceMethod, type = "filterStats"),
  nReducedDims = defaultNDims(x, reduceMethod, type = "reducedDims"),
  k0s = 4:15,
  subsample = TRUE,
  sequential = TRUE,
  clusterFunction = "hierarchical01",
  alphas = c(0.1, 0.2, 0.3),
  betas = 0.9,
  minSizes = 1,
  makeMissingDiss = if (ncol(x) < 1000) TRUE else FALSE,
  consensusProportion = 0.7,
  consensusMinSize,
  dendroReduce,
  dendroNDims,
  mergeMethod = "adjP",
  mergeCutoff,
  mergeLogFCcutoff,
  mergeDEMethod = if (isCount) "limma-voom" else "limma",
  verbose = FALSE,
  parameterWarnings = FALSE,
  mainClusterArgs = NULL,
  subsampleArgs = NULL,
  seqArgs = NULL,
  consensusArgs = NULL,
  whichAssay = 1,
  ncores = 1,
  random.seed = NULL,
  stopOnErrors = FALSE,
  run = TRUE
)
}
\arguments{
\item{x}{the data matrix on which to run the clustering. Can be object of the
following classes: matrix (with genes in rows),
\code{\link[SummarizedExperiment]{SummarizedExperiment}},
\code{\link[SingleCellExperiment]{SingleCellExperiment}}
or \code{ClusterExperiment}.}

\item{...}{For signature \code{matrix}, arguments to be passed on to mclapply
(if ncores>1). For all the other signatures, arguments to be passed to the
method for signature \code{matrix}.}

\item{eraseOld}{logical. Only relevant if input \code{x} is of class
\code{ClusterExperiment}. If TRUE, will erase existing workflow results
(clusterMany as well as mergeClusters and makeConsensus). If FALSE, existing
workflow results will have "\code{_i}" added to the clusterTypes value,
where \code{i} is one more than the largest such existing workflow
clusterTypes.}

\item{rerunClusterMany}{logical. If the object is a ClusterExperiment object,
determines whether to rerun the clusterMany step. Useful if want to try
different parameters for combining clusters after the clusterMany step,
without the computational costs of the clusterMany step.}

\item{isCount}{if \code{transFun=NULL}, then \code{isCount=TRUE} will
determine the transformation as defined by \code{function(x){log2(x+1)}},
and \code{isCount=FALSE} will give a transformation function
\code{function(x){x}}. Ignored if \code{transFun=NULL}. If object is of
class \code{ClusterExperiment}, the stored transformation will be used and
giving this parameter will result in an error.}

\item{transFun}{a transformation function to be applied to the data. If the
transformation applied to the data creates an error or NA values, then the
function will throw an error. If object is of class
\code{ClusterExperiment}, the stored transformation will be used and giving
this parameter will result in an error.}

\item{reduceMethod}{character A character identifying what type of
dimensionality reduction to perform before clustering. Options are 1)
"none", 2) one of listBuiltInReducedDims() or listBuiltInFitlerStats OR 3)
stored filtering or reducedDim values in the object.}

\item{nFilterDims}{vector of the number of the most variable features to keep
(when "var", "abscv", or "mad" is identified in \code{reduceMethod}).}

\item{nReducedDims}{vector of the number of dimensions to use (when
\code{reduceMethod} gives a dimensionality reduction method).}

\item{k0s}{the k0 parameter for sequential clustering (see
\code{\link{seqCluster}})}

\item{subsample}{logical as to whether to subsample via
\code{\link{subsampleClustering}}. If TRUE, clustering in mainClustering
step is done on the co-occurance between clusterings in the subsampled
clustering results.  If FALSE, the mainClustering step will be run directly
on \code{x}/\code{diss}}

\item{sequential}{logical whether to use the sequential strategy (see details
of \code{\link{seqCluster}}). Can be used in combination with
\code{subsample=TRUE} or \code{FALSE}.}

\item{clusterFunction}{function used for the clustering. This must be either 
1) a character vector of built-in clustering techniques, or 2) a
\emph{named} list of \code{\link{ClusterFunction}} objects. Current
functions can be found by typing \code{listBuiltInFunctions()} into the
command-line.}

\item{alphas}{values of alpha to be tried. Only used for clusterFunctions of
type '01'. Determines tightness required in creating clusters from the
dissimilarity matrix. Takes on values in [0,1]. See documentation of
\code{\link{ClusterFunction}}.}

\item{betas}{values of \code{beta} to be tried in sequential steps. Only used
for \code{sequential=TRUE}. Determines the similarity between two clusters
required in order to deem the cluster stable. Takes on values in [0,1]. See
documentation of \code{\link{seqCluster}}.}

\item{minSizes}{the minimimum size required for a cluster (in the
\code{mainClustering} step). Clusters smaller than this are not kept and samples
are left unassigned.}

\item{makeMissingDiss}{logical. Whether to calculate necessary distance 
matrices needed when input is not "diss". If TRUE, then when a clustering 
function calls for a inputType "diss", but the given matrix is of type "X",
the function will calculate a distance function. A dissimilarity matrix
will also be calculated if a post-processing argument like \code{findBestK}
or \code{removeSil} is chosen, since these rely on calcualting silhouette
widths from distances.}

\item{consensusProportion}{passed to \code{proportion} in
\code{\link{makeConsensus}}}

\item{consensusMinSize}{passed to \code{minSize} in
\code{\link{makeConsensus}}}

\item{dendroReduce}{passed to \code{reduceMethod} in
\code{\link{makeDendrogram}}}

\item{dendroNDims}{passed to \code{nDims} in \code{\link{makeDendrogram}}}

\item{mergeMethod}{passed to \code{mergeMethod} in
\code{\link{mergeClusters}}}

\item{mergeCutoff}{passed to \code{cutoff} in \code{\link{mergeClusters}}}

\item{mergeLogFCcutoff}{passed to \code{logFCcutoff} in
\code{\link{mergeClusters}}}

\item{mergeDEMethod}{passed to \code{DEMethod} argument in
  \code{\link{mergeClusters}}. By default, unless otherwise chosen by the
  user, if \code{isCount=TRUE}, then \code{mergeDEMethod="limma-voom"}, 
otherwise \code{mergeDEMethod="limma"}. These choices are for speed
 considerations and the user may want to try \code{mergeDEMethod="edgeR"} 
on smaller datasets of counts.}

\item{verbose}{logical. If TRUE it will print informative messages.}

\item{parameterWarnings}{logical, as to whether warnings and comments 
from checking the validity of the parameter combinations should be printed.}

\item{mainClusterArgs}{list of arguments to be passed for the mainClustering
step, see help pages of \code{\link{mainClustering}}.}

\item{subsampleArgs}{list of arguments to be passed to the subsampling step
(if \code{subsample=TRUE}), see help pages of
\code{\link{subsampleClustering}}.}

\item{seqArgs}{list of arguments to be passed to \code{\link{seqCluster}}.}

\item{consensusArgs}{list of additional arguments to be passed to
\code{\link{makeConsensus}}}

\item{whichAssay}{numeric or character specifying which assay to use. See
\code{\link[SummarizedExperiment]{assay}} for details.}

\item{ncores}{the number of threads}

\item{random.seed}{a value to set seed before each run of clusterSingle (so
that all of the runs are run on the same subsample of the data). Note, if
'random.seed' is set, argument 'ncores' should NOT be passed via
subsampleArgs; instead set the argument 'ncores' of clusterMany directly
(which is preferred for improving speed anyway).}

\item{stopOnErrors}{logical. If \code{FALSE}, if RSEC hits an error
\emph{after} the \code{clusterMany} step, it will return the results up to
that point, rather than generating a stop error. The text of error will be
printed as a NOTE. This allows the user to get the results to that point,
so as to not have to rerun the computationally heavy earlier steps. The
\code{TRUE} option is only provided for debugging purposes.}

\item{run}{logical. If FALSE, doesn't run clustering, but just returns matrix
of parameters that will be run, for the purpose of inspection by user (with
rownames equal to the names of the resulting column names of clMat object
that would be returned if \code{run=TRUE}). Even if \code{run=FALSE},
however, the function will create the dimensionality reductions of the data
indicated by the user input.}
}
\value{
A \code{\link{ClusterExperiment}} object is returned containing all
  of the clusterings from the steps of RSEC
}
\description{
Implementation of the RSEC algorithm (Resampling-based
  Sequential Ensemble Clustering) for single cell sequencing data. This is a
  wrapper function around the existing ClusterExperiment workflow that
  results in the output of RSEC.
}
\details{
Note that the argument \code{isCount} is mainly used when the input is a matrix or SingleCellExperiment Class and passed to \code{clusterMany} to set the transformation function of the data. However, if RSEC is being re-called on an existing \code{ClusterExperiment} object, it does not reset the transformation; in this case the only impact it will have is in setting the default value for \code{DEMethod} for \code{mergeClusters} step, but ONLY if \code{mergeClusters} hasn't already been calculated. To set arguments that allow you to recalculate the non-null probabilities of the hierarchy see \code{\link{mergeClusters}}.
}
