% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowClusters.R
\name{workflowClusters}
\alias{workflowClusters}
\alias{workflowClusterTable}
\alias{workflowClusterDetails}
\alias{workflowClusters,ClusterExperiment-method}
\alias{workflowClusterDetails,ClusterExperiment-method}
\alias{workflowClusterTable,ClusterExperiment-method}
\alias{setToCurrent,ClusterExperiment-method}
\alias{setToCurrent}
\alias{setToFinal,ClusterExperiment-method}
\alias{setToFinal}
\title{Methods for workflow clusters}
\usage{
\S4method{workflowClusters}{ClusterExperiment}(x, iteration = 0)

\S4method{workflowClusterDetails}{ClusterExperiment}(x)

\S4method{workflowClusterTable}{ClusterExperiment}(x)

\S4method{setToCurrent}{ClusterExperiment}(x, whichCluster, eraseOld = FALSE)

\S4method{setToFinal}{ClusterExperiment}(x, whichCluster, clusterLabel)
}
\arguments{
\item{x}{a \code{\link{ClusterExperiment}} object.}

\item{iteration}{numeric. Which iteration of the workflow should be used.}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{eraseOld}{logical. Only relevant if input \code{x} is of class
\code{ClusterExperiment}. If TRUE, will erase existing workflow results
(clusterMany as well as mergeClusters and makeConsensus). If FALSE, existing
workflow results will have "\code{_i}" added to the clusterTypes value,
where \code{i} is one more than the largest such existing workflow
clusterTypes.}

\item{clusterLabel}{optional string value to give to cluster set to be "final"}
}
\value{
\code{workflowClusters} returns a matrix consisting of the
  appropriate columns of the \code{clusterMatrix} slot.

\code{workflowClusterDetails} returns a \code{data.frame} with some
  details on the clusterings, such as the type (e.g., `clusterMany`,
  `makeConsensus`) and iteration.

\code{workflowClusterTable} returns a table of how many of the
  clusterings belong to each of the following possible values: `final`,
  `mergeClusters`, `makeConsensus` and `clusterMany`.

\code{setToCurrent} returns a \code{ClusterExperiment} object where
  the indicated cluster of \code{whichCluster} has been set to the most
  current iteration in the workflow. Pre-existing clusters are appropriately
  updated.

\code{setToFinal} returns a \code{ClusterExperiment} object where the
  indicated cluster of \code{whichCluster} has clusterType set to "final".
  The primaryClusterIndex is also set to this cluster, and the clusterLabel,
  if given.
}
\description{
The main workflow of the package is made of
  \code{\link{clusterMany}}, \code{\link{makeConsensus}}, and
  \code{\link{mergeClusters}}. The clusterings from these functions (and not
  those obtained in a different way) can be obtained with the functions
  documented here.
}
\examples{
\dontrun{
data(simData)

cl <- clusterMany(simData,nReducedDims=c(5,10,50),  reduceMethod="PCA",
clusterFunction="pam", ks=2:4, findBestK=c(FALSE), removeSil=TRUE,
subsample=FALSE, makeMissingDiss=TRUE)

clCommon <- makeConsensus(cl, whichClusters="workflow", proportion=0.7,
minSize=10)

clCommon <- makeDendrogram(clCommon)

clMerged <- mergeClusters(clCommon,mergeMethod="adjP", DEMethod="limma")

head(workflowClusters(clMerged))
workflowClusterDetails(clMerged)
workflowClusterTable(clMerged)
}
}
